VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4530
   ClientLeft      =   2325
   ClientTop       =   1710
   ClientWidth     =   6870
   Icon            =   "frmDIOBuffer.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4530
   ScaleWidth      =   6870
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Left            =   5880
      Top             =   1800
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   615
      Left            =   5520
      TabIndex        =   6
      Top             =   3600
      Width           =   735
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open and Init Driver"
      Height          =   375
      Left            =   960
      TabIndex        =   5
      Top             =   840
      Width           =   2295
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3480
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   840
      Width           =   615
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop IRQ mode Read"
      Enabled         =   0   'False
      Height          =   375
      Left            =   960
      TabIndex        =   3
      Top             =   2280
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   5880
      Top             =   1080
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.ListBox List1 
      Enabled         =   0   'False
      Height          =   840
      Left            =   3480
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   1560
      Width           =   1695
   End
   Begin VB.CommandButton cmdDIStart 
      Caption         =   "Start IRQ mode Read"
      Enabled         =   0   'False
      Height          =   375
      Left            =   960
      TabIndex        =   1
      Top             =   1560
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXSR SRDI 
      Left            =   5880
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3480
      TabIndex        =   8
      Top             =   600
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   480
      TabIndex        =   7
      Top             =   240
      Width           =   1845
   End
   Begin VB.Shape Shape1 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   1080
      Shape           =   3  'Circle
      Top             =   3000
      Width           =   375
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      Height          =   255
      Left            =   1680
      TabIndex        =   0
      Top             =   3000
      Width           =   3735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' VB6.0 application
' tested with KPCI-PIO24
' using KPCIPIO-850A04 driver revision in Win98SE
'
' the IRQ Enable line (Pin 2) must be pulled low
' apply the TTL IRQ Request signal to Pin 1

Private Sub cmdDIStart_Click()
List1.Clear
' set up paced mode digital input task
' init the DI subsystem
With SRDI
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DI
.Refresh
End With
With SRDI
.Req_op = DL_START
.Req_mode = DL_INTERRUPT
.Req_subsystem = DL_DI
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND  ' run until a stop operation is carried out
' timing information
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
.Evt_Tim_rateClock = DL_INTERNAL1  ' the KPCI-PIO has no clock so the PC System clock is used
.Evt_Tim_rateGate = DL_NOCONNECT
.Evt_Tim_rateMode = DL_RATEGEN
Dim rate As Single
rate = 1  ' 1 Hz.....max rate allowed is 1000 Hz
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, 1 / rate)  ' sample at 1Hz
' if the rate is increased, may need to also increase the size of the buffers.
' rate x buffer size = freq at which buffers become full and a message is sent
' Windoze messages can not go too fast...faster than 10 msec is quickly problematic
'
'
' channel and number of samples info
.Sel_buf_N = 10        ' these buffers will be recycled if the acquisition runs longer than 10 buffers
.Sel_buf_samples = 3   ' 3 samples....one for each channel
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages
.Sel_chan_N = 2              ' a start and a stop channel will be specified

.Sel_chan_start = 0          ' start at DI channel 0
.Sel_chan_stop = 2           ' stop at DI channel 2
                             ' total of 3 channels
.Sel_chan_format = DL_tNATIVE
.Sel_chan_simultaneousScan = True  ' scan all channels for each clock pulse
'.Req_op_edit = True
'.Refresh
.Refresh  ' start reading
End With
If SRDI.Res_result = DL_NoErr Then
cmdDIStart.Enabled = False
cmdStop.Enabled = True
Shape1.FillColor = vbGreen
lblStatus.Caption = "Buffered Digital Input Started...."
Timer1.Interval = 500  ' every half second
Timer1.Enabled = True
Else
SRDI.Req_op = DL_MESSAGEBOX
SRDI.Refresh
End If
End Sub



Private Sub cmdExit_Click()
' stop any task that could be active
With SRDI
.Req_op = DL_STOP
.Refresh
End With
' unload the driver
SRDI.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
With SRDI
.Req_DLL_name = "kpcipio$"  ' $ = load only kpcipio driver
.Req_device = devNum.ListIndex  ' devNum from combo box
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
lblStatus.Caption = SRDI.Message
' error check
If SRDI.Res_result = DL_NoErr Then
cmdDIStart.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SRDI.Req_DLL_name
LDD.device = SRDI.Req_device
LDD.Refresh  ' get fresh data about our board
Form1.Caption = "PC-System Clock to Pace Digital Input with Keithley " & LDD.Dev_Model
lblStatus.Caption = "Push the Start Button...."
Else
SRDI.Req_op = DL_MESSAGEBOX
SRDI.Refresh
End If
Form1.SetFocus  ' set focus back to our form
End Sub

Private Sub cmdStop_Click()
Timer1.Enabled = False
cmdStop.Enabled = False
cmdDIStart.Enabled = True
With SRDI
.Req_op = DL_STOP
.Refresh
End With
Shape1.FillColor = vbRed
lblStatus.Caption = "Buffered Digital Input stopped by request....."
End Sub


Private Sub Form_Load()
' center the form
   With Form1
        ' Center the form on the screen
        .Left = (Screen.Width - .Width) / 2
        .Top = (Screen.Height - .Height) / 2
   End With
' populate combo box with legal device numbers
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it equal to first entry
devNum.ListIndex = 0

End Sub


Private Sub SRDI_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
List1.Clear
Dim dummy As Long
Dim DIdata(3) As Byte  ' array same size as the buffer
Dim i As Integer
'move the data from memory buffer to our array
dummy = SRDI.VBArrayBufferXfer(bufIndex, DIdata, DL_BufferToVBArray)
If dummy = 0 Then
For i = 0 To 2
List1.AddItem "Chan " & Str(i) & " data :  " & Str(DIdata(i))
Next i
End If
Beep ' annoying beep
End Sub

Private Sub SRDI_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
lblStatus.Caption = "Clock Rate too fast.  Increase size or number of buffers"
End Sub

Private Sub Timer1_Timer()
With SRDI
.Req_op = DL_STATUS  ' let's ask DriverLINX for status info
.Res_Sta_typeStatus = DL_IOSTATUS
.Refresh
lblStatus.Caption = "Current Buffer is : " & Str(.Res_IO_currentBuffer)
End With
End Sub
